const modal = document.getElementById("bookingModal");
const openButtons = document.querySelectorAll(".hover-book-btn");
const closeModal = document.getElementById("closeModal");

openButtons.forEach((btn) => {
  btn.addEventListener("click", (e) => {
    e.preventDefault();
    modal.classList.add("show");
    document.body.style.overflow = "hidden";
  });
});

closeModal.addEventListener("click", () => {
  modal.classList.remove("show");
  document.body.style.overflow = "";
});

// Steps Logic
const steps = document.querySelectorAll(".step");
const formSteps = document.querySelectorAll(".form-step");
let currentStep = 0;

document.querySelectorAll(".next-btn").forEach((btn) => {
  btn.addEventListener("click", () => {
    formSteps[currentStep].classList.remove("active");
    currentStep++;
    formSteps[currentStep].classList.add("active");
    steps[currentStep].classList.add("active");
  });
});

document.querySelectorAll(".back-btn").forEach((btn) => {
  btn.addEventListener("click", () => {
    formSteps[currentStep].classList.remove("active");
    steps[currentStep].classList.remove("active");
    currentStep--;
    formSteps[currentStep].classList.add("active");
  });
});

// clear fillter
const clearBtn = document.querySelector(".clear-filters");
const checkboxes = document.querySelectorAll(
  ".filter-panel input[type='checkbox']"
);
const rangeInput = document.getElementById("priceRange");
const maxValue = document.getElementById("maxValue");
const selectedTagsContainer = document.getElementById("selectedTags");
const designCards = document.querySelectorAll(".design-card");

// 💰 Price update
rangeInput.addEventListener("input", function () {
  maxValue.textContent = `$${this.value}`;
  filterDesigns(); // update designs by price
});

// 🏷️ Add/Remove tags + filter grid
checkboxes.forEach((checkbox) => {
  checkbox.addEventListener("change", function () {
    const tagText = this.value;

    // Tag add/remove
    if (this.checked) {
      const tag = document.createElement("span");
      tag.className = "tag";
      tag.textContent = tagText;
      tag.setAttribute("data-value", tagText);
      selectedTagsContainer.appendChild(tag);
    } else {
      const tagToRemove = selectedTagsContainer.querySelector(
        `.tag[data-value="${tagText}"]`
      );
      if (tagToRemove) tagToRemove.remove();
    }

    filterDesigns(); // grid update
  });
});

// 🧹 Clear filters
clearBtn.addEventListener("click", () => {
  checkboxes.forEach((cb) => (cb.checked = false));
  rangeInput.value = 50;
  maxValue.textContent = `$${rangeInput.value}`;
  selectedTagsContainer.innerHTML = "";
  designCards.forEach((card) => (card.style.display = "block"));
  console.log("All filters cleared ✅");
});

// 🎯 Filter function
function filterDesigns() {
  const activeFilters = Array.from(checkboxes)
    .filter((cb) => cb.checked)
    .map((cb) => cb.value.toLowerCase());

  const currentPrice = parseInt(rangeInput.value);

  designCards.forEach((card) => {
    const tag = card
      .querySelector(".card-image .tag")
      .textContent.toLowerCase();
    const priceText = card.querySelector(".price").textContent;
    const price = parseInt(priceText.replace(/[^0-9]/g, ""));

    // Match logic: tag match OR price within range
    const matchesFilter =
      (activeFilters.length === 0 || activeFilters.includes(tag)) &&
      price <= currentPrice;

    card.style.display = matchesFilter ? "block" : "none";
  });
}












