// dh-tabs.js  -- encapsulated to avoid global pollution
(function () {
  "use strict";

  // helper: select elements
  var tabs = Array.prototype.slice.call(
    document.querySelectorAll("#dh-dashboard .dh-tab")
  );
  var panels = Array.prototype.slice.call(
    document.querySelectorAll("#dh-dashboard .dh-panel")
  );

  if (!tabs.length) return;

  function activateTab(tab) {
    var targetId = tab.getAttribute("data-target");

    // update tabs
    tabs.forEach(function (t) {
      var isActive = t === tab;
      t.classList.toggle("dh-tab-active", isActive);
      t.setAttribute("aria-selected", isActive ? "true" : "false");
      if (isActive) t.focus();
    });

    // update panels
    panels.forEach(function (p) {
      var show = p.id === targetId;
      p.classList.toggle("dh-panel-active", show);
      p.setAttribute("aria-hidden", show ? "false" : "true");
    });
  }

  // click handlers
  tabs.forEach(function (tab) {
    tab.addEventListener("click", function (e) {
      e.preventDefault();
      activateTab(tab);
    });

    // keyboard support: left/right arrows to navigate tabs
    tab.addEventListener("keydown", function (e) {
      var idx = tabs.indexOf(tab);
      if (e.key === "ArrowRight" || e.key === "ArrowDown") {
        e.preventDefault();
        var next = tabs[(idx + 1) % tabs.length];
        activateTab(next);
      } else if (e.key === "ArrowLeft" || e.key === "ArrowUp") {
        e.preventDefault();
        var prev = tabs[(idx - 1 + tabs.length) % tabs.length];
        activateTab(prev);
      } else if (e.key === "Home") {
        e.preventDefault();
        activateTab(tabs[0]);
      } else if (e.key === "End") {
        e.preventDefault();
        activateTab(tabs[tabs.length - 1]);
      }
    });
  });

  // Initialize (ensure one is active)
  var active =
    tabs.find(function (t) {
      return t.classList.contains("dh-tab-active");
    }) || tabs[0];
  if (active) activateTab(active);
})();
